/*
 * Decompiled with CFR 0.152.
 */
package com.odroid.ballena.spring;

import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.resource.PathResourceResolver;

public class SpaPathResourceResolver
extends PathResourceResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpaPathResourceResolver.class);
    private final String mainClassPath;

    public SpaPathResourceResolver(String mainClassPath) {
        this.mainClassPath = mainClassPath;
    }

    protected Resource getResource(String resourcePath, Resource location) throws IOException {
        Resource requestedResource = location.createRelative(resourcePath);
        if (requestedResource.exists()) {
            log.debug("Looking for {} at {} resolved as {}: found", new Object[]{resourcePath, location, requestedResource});
            return requestedResource;
        }
        log.debug("Looking for {} at {} resolved as {}: not found, using {}", new Object[]{resourcePath, location, requestedResource, this.mainClassPath});
        return new ClassPathResource(this.mainClassPath);
    }
}

