/*
 * Decompiled with CFR 0.152.
 */
package com.odroid.ballena.spring;

import com.odroid.ballena.domain.Authority;
import com.odroid.ballena.security.LoggedUserProviderAuthenticationSuccessHandler;
import com.odroid.ballena.security.Status200LogoutSuccessHandler;
import com.odroid.ballena.security.Status401AuthenticationFailureHandler;
import com.odroid.ballena.spring.AppSecurityConfiguration;
import jakarta.servlet.Filter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;

@Configuration
@Order(value=2)
public class AppSecurityConfiguration {
    private static final String WEB_URL_PATTERN = "/ballena/web/**";
    private static final String PUBLIC_REST_URL_PATTERN = "/ballena/rest/ping/**";
    private static final String LOGIN_URL = "/ballena/rest/login";
    private static final String LOGOUT_URL = "/ballena/rest/logout";
    private static final String SESSION_COOKIE = "JSESSIONID";
    private static final String USERNAME_PARAMETER = "username";
    private static final String PASS_PARAMETER = "password";

    @Bean
    public SecurityFilterChain appSecurityFilterChain(HttpSecurity http) throws Exception {
        http.exceptionHandling(httpSecurityExceptionHandlingConfigurer -> httpSecurityExceptionHandlingConfigurer.authenticationEntryPoint(this.restAuthenticationEntryPoint())).authorizeHttpRequests(authorizationManagerRequestMatcherRegistry -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry.requestMatchers(new String[]{"/", "/ballena/", WEB_URL_PATTERN, PUBLIC_REST_URL_PATTERN})).permitAll().anyRequest()).hasRole(Authority.ROLE_USER.getShortForm())).formLogin(httpSecurityFormLoginConfigurer -> ((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)httpSecurityFormLoginConfigurer.loginProcessingUrl(LOGIN_URL)).usernameParameter(USERNAME_PARAMETER).passwordParameter(PASS_PARAMETER).permitAll()).successHandler(this.restAuthenticationSuccessHandler())).failureHandler(this.restAuthenticationFailureHandler())).logout(httpSecurityLogoutConfigurer -> httpSecurityLogoutConfigurer.logoutUrl(LOGOUT_URL).deleteCookies(new String[]{SESSION_COOKIE}).permitAll().logoutSuccessHandler(this.logoutSuccessHandler())).csrf(httpSecurityCsrfConfigurer -> httpSecurityCsrfConfigurer.csrfTokenRepository((CsrfTokenRepository)CookieCsrfTokenRepository.withHttpOnlyFalse()).csrfTokenRequestHandler((CsrfTokenRequestHandler)new SpaCsrfTokenRequestHandler())).addFilterAfter((Filter)new SpaCsrfCookieFilter(), BasicAuthenticationFilter.class);
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public AuthenticationEntryPoint restAuthenticationEntryPoint() {
        return new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED);
    }

    @Bean
    public AuthenticationSuccessHandler restAuthenticationSuccessHandler() {
        return new LoggedUserProviderAuthenticationSuccessHandler();
    }

    @Bean
    public AuthenticationFailureHandler restAuthenticationFailureHandler() {
        return new Status401AuthenticationFailureHandler();
    }

    @Bean
    public LogoutSuccessHandler logoutSuccessHandler() {
        return new Status200LogoutSuccessHandler();
    }
}

