/*
 * Decompiled with CFR 0.152.
 */
package com.odroid.ballena.service.impl.users;

import com.odroid.ballena.domain.Authority;
import com.odroid.ballena.domain.User;
import com.odroid.ballena.domain.UserAuthority;
import com.odroid.ballena.repository.UsersAuthoritiesRepository;
import com.odroid.ballena.repository.UsersRepository;
import com.odroid.ballena.security.IsAdminPreAuthorize;
import com.odroid.ballena.service.iface.errors.ConcurrencyException;
import com.odroid.ballena.service.iface.errors.NotFoundException;
import com.odroid.ballena.service.iface.users.DetailedUser;
import com.odroid.ballena.service.iface.users.MinimalUser;
import com.odroid.ballena.service.iface.users.UsersService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
@IsAdminPreAuthorize
public class UsersServiceJpaImpl
implements UsersService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UsersServiceJpaImpl.class);
    private static final String USER = "User";
    private static final String DEFAULT_NAME = "Qwerty Uiop";
    private final UsersRepository usersRepository;
    private final UsersAuthoritiesRepository usersAuthoritiesRepository;
    private final PasswordEncoder passwordEncoder;
    @PersistenceContext
    private EntityManager em;

    public UsersServiceJpaImpl(UsersRepository usersRepository, UsersAuthoritiesRepository usersAuthoritiesRepository, PasswordEncoder passwordEncoder) {
        this.usersRepository = usersRepository;
        this.usersAuthoritiesRepository = usersAuthoritiesRepository;
        this.passwordEncoder = passwordEncoder;
    }

    public List<MinimalUser> findUsers(String filter, long from, long limit) {
        LOGGER.debug("Filtering {} users from {} with {}", new Object[]{limit, from, filter});
        try (Stream usersStream = this.usersRepository.findUsers(filter);){
            List<MinimalUser> users = usersStream.skip(from).limit(limit).map(MinimalUser::fromUser).toList();
            LOGGER.debug("Filtered users: {}", users);
            List<MinimalUser> list = users;
            return list;
        }
    }

    private User getUserOrThrow(Long id, Long version) {
        User user = this.getUserOrThrow(id);
        if (!version.equals(user.getVersion())) {
            throw new ConcurrencyException();
        }
        return user;
    }

    private User getUserOrThrow(Long id) {
        return (User)this.usersRepository.findById((Object)id).orElseThrow(() -> new NotFoundException(USER, id));
    }

    public DetailedUser getUser(Long id) {
        LOGGER.debug("Getting user {}", (Object)id);
        DetailedUser user = DetailedUser.fromUser((User)this.getUserOrThrow(id));
        LOGGER.debug("Got user: {}", (Object)user);
        return user;
    }

    @Transactional
    public Long createUser() {
        LOGGER.debug("Creating user");
        User user = User.builder().username("0_" + UUID.randomUUID().toString()).hash(this.passwordEncoder.encode((CharSequence)UUID.randomUUID().toString())).enabled(Boolean.valueOf(false)).name(DEFAULT_NAME).build();
        user.getUserAuthorities().add(UserAuthority.builder().user(user).authority(Authority.ROLE_USER).build());
        user = (User)this.usersRepository.save((Object)user);
        Long userId = user.getId();
        LOGGER.debug("Created user {}", (Object)userId);
        return userId;
    }

    @Transactional
    public void updateUser(DetailedUser detailedUser) {
        User user = this.getUserOrThrow(detailedUser.getId(), detailedUser.getVersion());
        user.setUsername(detailedUser.getUsername());
        user.setName(detailedUser.getName());
        user.setEnabled(detailedUser.getEnabled());
        if (!user.getHash().equals(detailedUser.getHash())) {
            user.setHash(this.passwordEncoder.encode((CharSequence)detailedUser.getHash()));
        }
        if (Boolean.TRUE.equals(detailedUser.getAdmin())) {
            if (!user.isAdmin()) {
                user.getUserAuthorities().add(UserAuthority.builder().user(user).authority(Authority.ROLE_ADMIN).build());
            }
        } else if (user.isAdmin()) {
            UserAuthority adminUserAuthority = user.getUserAuthorities().stream().filter(userAuthority -> userAuthority.getAuthority().equals((Object)Authority.ROLE_ADMIN)).findFirst().orElseThrow(IllegalStateException::new);
            user.getUserAuthorities().remove(adminUserAuthority);
            this.usersAuthoritiesRepository.delete((Object)adminUserAuthority);
        }
    }

    @Transactional
    public void deleteUser(Long id) {
        LOGGER.debug("Deleting user {}", (Object)id);
        User user = this.getUserOrThrow(id);
        this.usersRepository.delete((Object)user);
        LOGGER.debug("Deleted user {}", (Object)id);
    }
}

