/*
 * Decompiled with CFR 0.152.
 */
package com.odroid.ballena.service.impl.notes;

import com.odroid.ballena.domain.Note;
import com.odroid.ballena.domain.User;
import com.odroid.ballena.repository.NotesRepository;
import com.odroid.ballena.repository.UsersRepository;
import com.odroid.ballena.service.iface.errors.ConcurrencyException;
import com.odroid.ballena.service.iface.errors.ForbiddenException;
import com.odroid.ballena.service.iface.errors.NotFoundException;
import com.odroid.ballena.service.iface.lorem.LoremService;
import com.odroid.ballena.service.iface.notes.DetailedNote;
import com.odroid.ballena.service.iface.notes.MinimalNote;
import com.odroid.ballena.service.iface.notes.NotesService;
import com.odroid.ballena.service.iface.notes.WrongNoteException;
import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class NotesServiceJpaImpl
implements NotesService {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotesServiceJpaImpl.class);
    private static final String NOTE = "Note";
    private static final String WRONG_NOTE_IDENTIFIER = "3RR0R";
    private static final String HORROR_NOTE_IDENTIFIER = "H0RR0R";
    private static final String ERROR_FIND_NPE = "FAIL";
    private final NotesRepository notesRepository;
    private final UsersRepository usersRepository;
    private final LoremService loremService;

    public NotesServiceJpaImpl(NotesRepository notesRepository, UsersRepository usersRepository, LoremService loremService) {
        this.notesRepository = notesRepository;
        this.usersRepository = usersRepository;
        this.loremService = loremService;
    }

    public List<MinimalNote> findNotes(String filter, String username, long from, long limit) {
        LOGGER.debug("Filtering {} notes from {} for {} with {}", new Object[]{limit, from, username, filter});
        if (filter.contains(ERROR_FIND_NPE)) {
            throw new NullPointerException();
        }
        try (Stream notesStream = this.notesRepository.findNotes(filter, username);){
            List<MinimalNote> notes = notesStream.skip(from).limit(limit).map(MinimalNote::fromNote).toList();
            LOGGER.debug("Filtered notes: {}", notes);
            List<MinimalNote> list = notes;
            return list;
        }
    }

    public DetailedNote getNote(Long id, String username) {
        LOGGER.debug("Getting note {} for {}", (Object)id, (Object)username);
        DetailedNote note = DetailedNote.fromNote((Note)this.getNoteOwnedBy(id, username));
        if (note.getTitle().contains(HORROR_NOTE_IDENTIFIER)) {
            throw new WrongNoteException(note.getTitle());
        }
        LOGGER.debug("Got note: {}", (Object)note);
        return note;
    }

    private Note getNoteOwnedBy(Long id, String username, Long version) {
        Note note = this.getNoteOwnedBy(id, username);
        if (!version.equals(note.getVersion())) {
            throw new ConcurrencyException();
        }
        return note;
    }

    private Note getNoteOwnedBy(Long id, String username) {
        Note note = (Note)this.notesRepository.findById((Object)id).orElseThrow(() -> new NotFoundException(NOTE, id));
        if (!note.getUser().getUsername().equals(username)) {
            throw new ForbiddenException();
        }
        return note;
    }

    @Transactional
    public Long createNote(String username) {
        LOGGER.debug("Creating note for {}", (Object)username);
        User user = this.usersRepository.findByUsername(username);
        String title = ".";
        String content = "";
        try {
            title = this.loremService.generateWords(Integer.valueOf(2));
            content = this.loremService.generateParagraph(Boolean.valueOf(true));
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        Note note = Note.builder().title(title).content(content).user(user).build();
        Note savedNote = (Note)this.notesRepository.save((Object)note);
        Long noteId = savedNote.getId();
        LOGGER.debug("Created note {}", (Object)noteId);
        return noteId;
    }

    @Transactional
    public void updateNote(DetailedNote detailedNote, String username) {
        LOGGER.debug("Updating note {} for {}", (Object)detailedNote, (Object)username);
        if (detailedNote.getTitle().contains(WRONG_NOTE_IDENTIFIER)) {
            throw new WrongNoteException(detailedNote.getTitle());
        }
        Note note = this.getNoteOwnedBy(detailedNote.getId(), username, detailedNote.getVersion());
        note.setTitle(detailedNote.getTitle());
        note.setContent(detailedNote.getContent());
        LOGGER.debug("Updated note {}", (Object)detailedNote);
    }

    @Transactional
    public void deleteNote(Long id, String username) {
        LOGGER.debug("Deleting note {} for {}", (Object)id, (Object)username);
        Note note = this.getNoteOwnedBy(id, username);
        this.notesRepository.delete((Object)note);
        LOGGER.debug("Deleted note {}", (Object)id);
    }
}

