/*
 * Decompiled with CFR 0.152.
 */
package com.odroid.ballena.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.odroid.ballena.security.LoggedUser;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

public class LoggedUserProviderAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoggedUserProviderAuthenticationSuccessHandler.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        User user = (User)authentication.getPrincipal();
        log.debug("Authenticated {}", (Object)user);
        List<String> roles = user.getAuthorities().stream().map(GrantedAuthority::getAuthority).toList();
        LoggedUser loggedUser = new LoggedUser(user.getUsername(), roles);
        String loggedUserJson = this.objectMapper.writeValueAsString((Object)loggedUser);
        try (ServletOutputStream os = response.getOutputStream();){
            os.write(loggedUserJson.getBytes());
        }
    }
}

