/*
 * Decompiled with CFR 0.152.
 */
package com.odroid.ballena.rest.users;

import com.odroid.ballena.common.AppConfiguration;
import com.odroid.ballena.rest.LinkedDataException;
import com.odroid.ballena.rest.users.UsernameCollisionException;
import com.odroid.ballena.service.iface.users.DetailedUser;
import com.odroid.ballena.service.iface.users.MinimalUser;
import com.odroid.ballena.service.iface.users.UsersService;
import java.util.List;
import org.hibernate.exception.ConstraintViolationException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ballena/rest/users"})
public class UsersRestController {
    private final UsersService usersService;
    private final AppConfiguration appConfiguration;

    public UsersRestController(UsersService usersService, AppConfiguration appConfiguration) {
        this.usersService = usersService;
        this.appConfiguration = appConfiguration;
    }

    @GetMapping(value={""}, produces={"application/json"})
    public List<MinimalUser> find(@RequestParam(value="filter", defaultValue="") String filter, @RequestParam(value="from", defaultValue="0") long from) {
        return this.usersService.findUsers(filter.replaceAll("[\n\r\t]", "_"), from, (long)this.appConfiguration.getPageSize().intValue());
    }

    @GetMapping(value={"/{id}"}, produces={"application/json"})
    public DetailedUser retrieve(@PathVariable(value="id") Long id) {
        return this.usersService.getUser(id);
    }

    @PostMapping(value={""}, produces={"application/json"})
    public Long create() {
        return this.usersService.createUser();
    }

    @PutMapping(value={""}, consumes={"application/json"})
    public DetailedUser update(@RequestBody DetailedUser user) {
        try {
            this.usersService.updateUser(user);
            return this.usersService.getUser(user.getId());
        }
        catch (DataIntegrityViolationException e) {
            ConstraintViolationException cve;
            Throwable throwable = e.getCause();
            if (throwable instanceof ConstraintViolationException && (cve = (ConstraintViolationException)throwable).getConstraintName().equalsIgnoreCase("users_username_unique")) {
                throw new UsernameCollisionException();
            }
            throw e;
        }
    }

    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable(value="id") Long id) {
        try {
            this.usersService.deleteUser(id);
        }
        catch (DataIntegrityViolationException e) {
            throw new LinkedDataException((Throwable)e);
        }
    }
}

