/*
 * Decompiled with CFR 0.152.
 */
package com.odroid.ballena.rest.notes;

import com.odroid.ballena.common.AppConfiguration;
import com.odroid.ballena.service.iface.notes.DetailedNote;
import com.odroid.ballena.service.iface.notes.MinimalNote;
import com.odroid.ballena.service.iface.notes.NotesService;
import java.security.Principal;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ballena/rest/notes"})
public class NotesRestController {
    private final NotesService notesService;
    private final AppConfiguration appConfiguration;

    public NotesRestController(NotesService notesService, AppConfiguration appConfiguration) {
        this.notesService = notesService;
        this.appConfiguration = appConfiguration;
    }

    @GetMapping(value={""}, produces={"application/json"})
    public List<MinimalNote> find(@RequestParam(value="filter", defaultValue="") String filter, @RequestParam(value="from", defaultValue="0") long from, Principal principal) {
        return this.notesService.findNotes(filter.replaceAll("[\n\r\t]", "_"), principal.getName(), from, (long)this.appConfiguration.getPageSize().intValue());
    }

    @GetMapping(value={"/{id}"}, produces={"application/json"})
    public DetailedNote retrieve(@PathVariable(value="id") Long id, Principal principal) {
        return this.notesService.getNote(id, principal.getName());
    }

    @PostMapping(value={""}, produces={"application/json"})
    public Long create(Principal principal) {
        return this.notesService.createNote(principal.getName());
    }

    @PutMapping(value={""}, consumes={"application/json"})
    public DetailedNote update(@RequestBody DetailedNote note, Principal principal) {
        this.notesService.updateNote(note, principal.getName());
        return this.notesService.getNote(note.getId(), principal.getName());
    }

    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable(value="id") Long id, Principal principal) {
        this.notesService.deleteNote(id, principal.getName());
    }
}

