/*
 * Decompiled with CFR 0.152.
 */
package com.odroid.ballena.domain;

import com.odroid.ballena.domain.Authority;
import com.odroid.ballena.domain.Note;
import com.odroid.ballena.domain.User;
import com.odroid.ballena.domain.UserAuthority;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

@Entity
@Table(name="users")
public class User
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    @NonNull
    private String username;
    @Column
    @NonNull
    private String hash;
    @Column
    @NonNull
    private Boolean enabled;
    @Column
    @NonNull
    private String name;
    @Version
    @NonNull
    private Long version;
    @OneToMany(mappedBy="user", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<UserAuthority> userAuthorities = new ArrayList();
    @OneToMany(mappedBy="user", fetch=FetchType.LAZY)
    private List<Note> notes = new ArrayList();

    private User(String username, String hash, Boolean enabled, String name, Long version) {
        this.username = username;
        this.hash = hash;
        this.enabled = enabled;
        this.name = name;
        this.version = version;
        this.userAuthorities = new ArrayList();
        this.notes = new ArrayList();
    }

    public boolean isAdmin() {
        long adminCount = this.getUserAuthorities().stream().filter(userAuthority -> userAuthority.getAuthority().equals((Object)Authority.ROLE_ADMIN)).count();
        return adminCount > 0L;
    }

    @Generated
    public static UserBuilder builder() {
        return new UserBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getUsername() {
        return this.username;
    }

    @NonNull
    @Generated
    public String getHash() {
        return this.hash;
    }

    @NonNull
    @Generated
    public Boolean getEnabled() {
        return this.enabled;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @NonNull
    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Generated
    public List<UserAuthority> getUserAuthorities() {
        return this.userAuthorities;
    }

    @Generated
    public List<Note> getNotes() {
        return this.notes;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setUsername(@NonNull String username) {
        if (username == null) {
            throw new IllegalArgumentException("username is marked non-null but is null");
        }
        this.username = username;
    }

    @Generated
    public void setHash(@NonNull String hash) {
        if (hash == null) {
            throw new IllegalArgumentException("hash is marked non-null but is null");
        }
        this.hash = hash;
    }

    @Generated
    public void setEnabled(@NonNull Boolean enabled) {
        if (enabled == null) {
            throw new IllegalArgumentException("enabled is marked non-null but is null");
        }
        this.enabled = enabled;
    }

    @Generated
    public void setName(@NonNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @Generated
    public void setUserAuthorities(List<UserAuthority> userAuthorities) {
        this.userAuthorities = userAuthorities;
    }

    @Generated
    public void setNotes(List<Note> notes) {
        this.notes = notes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof User;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "User(id=" + this.getId() + ", username=" + this.getUsername() + ", hash=" + this.getHash() + ", enabled=" + this.getEnabled() + ", name=" + this.getName() + ", version=" + this.getVersion() + ")";
    }

    @Generated
    public User() {
    }
}

